// Training page module (light placeholder)
(function () {
  window.pages = window.pages || {};

  async function render(container) {
    container.innerHTML = `
      <div class="card">
        <div class="card-header">
          <h5 class="card-title mb-0">Training</h5>
        </div>
        <div class="card-body">
          <p class="text-muted">This module will list trainings and enrollments. Basic summary is shown below.</p>
          <div id="trainingSummary">Loading...</div>
        </div>
      </div>
    `;

    try {
      const res = await fetch('api/training.php', { credentials: 'same-origin' });
      const data = await res.json();
      const el = container.querySelector('#trainingSummary');
      if (data?.success) {
        const arr = Array.isArray(data.data) ? data.data : [];
        el.innerHTML = `<div class="stats-card"><div class="value">${arr.length}</div><div class="label">Training items</div></div>`;
      } else {
        el.textContent = 'Unable to load training data';
      }
    } catch (_) {
      const el = container.querySelector('#trainingSummary');
      if (el) el.textContent = 'Unable to load training data';
    }
  }

  window.pages.training = { render };
})();
