// Notifications handler
(function () {
  async function triggerEventNotifications() {
    try {
      await fetch('api/calendar.php?action=notify_due', { method: 'POST', credentials: 'same-origin' });
    } catch (_) {}
  }
  async function triggerDocAckNotifications() {
    try {
      await fetch('api/documents.php?action=notify_due', { method: 'POST', credentials: 'same-origin' });
    } catch (_) {}
  }
  async function fetchUnreadCount() {
    try {
      const res = await fetch('api/notifications.php?action=unread_count', { credentials: 'same-origin' });
      const data = await res.json();
      const c = document.getElementById('notificationCount');
      if (data?.success && c) {
        const n = data.data?.unread ?? 0;
        c.textContent = n;
        c.style.display = n > 0 ? 'inline-block' : 'none';
      }
    } catch (_) {}
  }

  async function fetchNotifications() {
    try {
      const res = await fetch('api/notifications.php?limit=10', { credentials: 'same-origin' });
      const data = await res.json();
      const list = document.getElementById('notificationList');
      if (!list) return;
      list.innerHTML = '';

      const header = document.createElement('li');
      header.innerHTML = '<h6 class="dropdown-header">Notifications</h6>';
      list.appendChild(header);

      const markAll = document.createElement('li');
      markAll.innerHTML = '<a class="dropdown-item text-primary" href="#" id="markAllRead">Mark all as read</a>';
      list.appendChild(markAll);

      if (data?.success && Array.isArray(data.data) && data.data.length) {
        data.data.forEach(n => {
          const li = document.createElement('li');
          li.innerHTML = `<a class="dropdown-item" href="#" data-id="${n.id}" data-type="${(n.type||'').replace(/"/g,'&quot;')}" data-data='${(n.data||'').replace(/'/g,"&#39;")}'>
            <div class="d-flex flex-column">
              <strong>${escapeHtml(n.title || 'Notification')}</strong>
              <small class="text-muted">${escapeHtml(n.content || '')}</small>
            </div>
          </a>`;
          list.appendChild(li);
        });
        // Bind click handlers for each notification
        list.querySelectorAll('a.dropdown-item[data-id]').forEach(a => {
          if (a._bound) return; a._bound = true;
          a.addEventListener('click', async (e)=>{
            e.preventDefault();
            const id = a.getAttribute('data-id');
            try{ await fetch(`api/notifications.php?action=read&id=${encodeURIComponent(id)}`, { method:'POST', credentials:'same-origin' }); }catch(_){ }
            // Determine target route
            let target = '#/notifications';
            try{
              const t = a.getAttribute('data-type') || '';
              const raw = a.getAttribute('data-data') || '';
              const dataJson = raw ? JSON.parse(raw) : null;
              if (t==='promotion_letter' || t==='document_ack') target = '#/documents';
              else if (t==='appraisal_assignment') target = '#/appraisal';
              else if (t==='training_invite') target = '#/training';
              else if (t==='leave_request' || t==='leave_action') target = '#/leave';
              else if (dataJson && typeof dataJson === 'object' && dataJson.route){ target = `#/${dataJson.route}`; }
            }catch(_){ }
            window.location.hash = target;
            // Update counters and list
            fetchUnreadCount(); fetchNotifications();
          });
        });
      } else {
        const empty = document.createElement('li');
        empty.innerHTML = '<span class="dropdown-item text-muted">No notifications</span>';
        list.appendChild(empty);
      }

      const markAllBtn = document.getElementById('markAllRead');
      if (markAllBtn) {
        markAllBtn.addEventListener('click', async (e) => {
          e.preventDefault();
          try {
            await fetch('api/notifications.php?action=read_all', { method: 'POST', credentials: 'same-origin' });
            await fetchUnreadCount();
            await fetchNotifications();
          } catch (_) {}
        });
      }
    } catch (_) {}
  }

  function escapeHtml(s) {
    return String(s ?? '').replace(/[&<>"']/g, (c) => ({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;','\'':'&#39;'}[c]));
  }

  // Attach event to dropdown open
  document.addEventListener('DOMContentLoaded', () => {
    const dd = document.getElementById('notificationDropdown');
    if (dd) {
      dd.addEventListener('click', () => {
        fetchNotifications();
      });
    }

    // initial load and polling
    fetchUnreadCount();
    // trigger planner notifications for upcoming events
    triggerEventNotifications();
    // trigger document acknowledgment reminders
    triggerDocAckNotifications();
    setInterval(fetchUnreadCount, 30000);
    setInterval(triggerEventNotifications, 60000);
    setInterval(triggerDocAckNotifications, 90000);
  });

  // ===== Notifications Page =====
  window.pages = window.pages || {};
  window.pages.notifications = { render: async function(container){
    container.innerHTML = `<div class="card">
      <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Notifications</h5>
        <div>
          <button class="btn btn-sm btn-outline-primary" id="notifMarkAll"><i class="fas fa-check-double"></i> Mark all as read</button>
        </div>
      </div>
      <div class="card-body">
        <div class="d-flex gap-2 mb-2">
          <select id="notifStatus" class="form-select form-select-sm" style="width:160px"><option value="all">All</option><option value="unread">Unread</option></select>
        </div>
        <div id="notifListWrap">Loading...</div>
        <div class="d-flex justify-content-between align-items-center mt-3">
          <button class="btn btn-sm btn-outline-secondary" id="notifPrev">Prev</button>
          <div class="small text-muted" id="notifInfo"></div>
          <button class="btn btn-sm btn-outline-secondary" id="notifNext">Next</button>
        </div>
      </div>
    </div>`;

    const listWrap = container.querySelector('#notifListWrap');
    const info = container.querySelector('#notifInfo');
    const statusSel = container.querySelector('#notifStatus');
    let page = 1; const pageSize = 20;

    async function loadPage(){
      listWrap.innerHTML = 'Loading...';
      try{
        const offset = (page-1)*pageSize;
        const url = `api/notifications.php?status=${encodeURIComponent(statusSel.value)}&limit=${pageSize}&offset=${offset}`;
        const r = await fetch(url, { credentials:'same-origin' }); const j = await r.json();
        const items = j?.success && Array.isArray(j.data) ? j.data : [];
        if (!items.length){ listWrap.innerHTML = '<div class="text-muted">No notifications</div>'; info.textContent = `Page ${page}`; return; }
        listWrap.innerHTML = items.map(n=>`<div class="border rounded p-2 mb-2" data-id="${n.id}" data-type="${(n.type||'')}">
          <div class="d-flex justify-content-between">
            <div><strong>${escapeHtml(n.title||'Notification')}</strong><div class="small text-muted">${escapeHtml(n.content||'')}</div></div>
            <div class="small ${n.read_at? 'text-muted':'text-primary'}">${n.read_at? 'Read' : 'Unread'}</div>
          </div>
        </div>`).join('');
        info.textContent = `Page ${page}`;
        // bind row clicks
        listWrap.querySelectorAll('[data-id]').forEach(div=>{
          if (div._b) return; div._b=true; div.addEventListener('click', async()=>{
            const id = div.getAttribute('data-id');
            try{ await fetch(`api/notifications.php?action=read&id=${encodeURIComponent(id)}`, { method:'POST', credentials:'same-origin' }); }catch(_){ }
            let target = '#/notifications'; const typ = div.getAttribute('data-type')||'';
            if (typ==='promotion_letter' || typ==='document_ack') target = '#/documents';
            else if (typ==='appraisal_assignment') target = '#/appraisal';
            else if (typ==='training_invite') target = '#/training';
            else if (typ==='leave_request' || typ==='leave_action') target = '#/leave';
            window.location.hash = target; fetchUnreadCount();
          });
        });
      }catch(_){ listWrap.innerHTML = '<div class="text-danger">Failed to load notifications</div>'; }
    }

    container.querySelector('#notifPrev').addEventListener('click', ()=>{ if (page>1){ page--; loadPage(); } });
    container.querySelector('#notifNext').addEventListener('click', ()=>{ page++; loadPage(); });
    statusSel.addEventListener('change', ()=>{ page=1; loadPage(); });
    container.querySelector('#notifMarkAll').addEventListener('click', async ()=>{ try{ await fetch('api/notifications.php?action=read_all', { method:'POST', credentials:'same-origin' }); loadPage(); fetchUnreadCount(); }catch(_){ } });

    loadPage();
  }};
})();
