// Staff/Manager Dashboard module
(function(){
  window.pages = window.pages || {};

  function escapeHtml(s){ return String(s ?? '').replace(/[&<>"']/g, c=>({"&":"&amp;","<":"&lt;",">":"&gt;","\"":"&quot;","'":"&#39;"}[c])); }
  function formatDate(s){ try{ return new Date(String(s).replace(' ','T')).toLocaleDateString(); }catch(_){ return s||''; } }
  function formatDateTime(s){ try{ return new Date(String(s).replace(' ','T')).toLocaleString(); }catch(_){ return s||''; } }
  function greeting(){ const h=(new Date()).getHours(); if (h<12) return 'Good Morning'; if (h<17) return 'Good Afternoon'; return 'Good Evening'; }

  async function render(container){
    const user = window.auth?.currentUser || {};
    const firstName = user.first_name || 'User';
    const year = new Date().getFullYear();

    container.innerHTML = `
      <div class="row">
        <div class="col-12">
          <div class="card mb-3">
            <div class="card-header d-flex justify-content-between align-items-center">
              <div>
                <h5 class="mb-0"><span id="greetText">${greeting()}</span>, ${escapeHtml(firstName)}</h5>
                <small class="text-muted" id="clockNow"></small>
              </div>
              <button class="btn btn-sm btn-outline-primary" id="dashSfRefresh"><i class="fas fa-rotate"></i> Refresh</button>
            </div>
            <div class="card-body py-2">
              <div id="annTicker" class="small text-nowrap overflow-hidden" style="white-space:nowrap;"></div>
            </div>
          </div>
        </div>
      </div>

      <div class="row g-3">
        <div class="col-lg-4">
          <div class="card h-100">
            <div class="card-header"><h6 class="mb-0">My Profile</h6></div>
            <div class="card-body" id="sfProfile">Loading...</div>
          </div>
        </div>
        <div class="col-lg-4">
          <div class="card h-100">
            <div class="card-header d-flex justify-content-between align-items-center">
              <h6 class="mb-0">New Documents for You (7 days)</h6>
              <a href="#/documents" onclick="app.showPage('documents');return false;" class="small">View all</a>
            </div>
            <div class="card-body p-0">
              <ul class="list-group list-group-flush" id="sfDocsList"><li class="list-group-item text-muted">Loading...</li></ul>
            </div>
          </div>
        </div>
        <div class="col-lg-4">
          <div class="card h-100">
            <div class="card-header d-flex justify-content-between align-items-center"><h6 class="mb-0">My Messages</h6><a href="#/messages" onclick="app.showPage('messages');return false;" class="small">Open</a></div>
            <div class="card-body p-0"><ul class="list-group list-group-flush" id="sfMsgList"><li class="list-group-item text-muted">Loading...</li></ul></div>
          </div>
        </div>
      </div>

      <div class="row g-3 mt-1">
        <div class="col-lg-6">
          <div class="card h-100">
            <div class="card-header d-flex justify-content-between align-items-center"><h6 class="mb-0">Upcoming Birthdays (7 days)</h6><small id="sfBdRange" class="text-muted"></small></div>
            <div class="card-body p-0"><ul class="list-group list-group-flush" id="sfBdList"><li class="list-group-item text-muted">Loading...</li></ul></div>
          </div>
        </div>
        <div class="col-lg-6">
          <div class="card h-100">
            <div class="card-header d-flex justify-content-between align-items-center"><h6 class="mb-0">Upcoming Work Anniversaries (7 days)</h6><small id="sfAnRange" class="text-muted"></small></div>
            <div class="card-body p-0"><ul class="list-group list-group-flush" id="sfAnList"><li class="list-group-item text-muted">Loading...</li></ul></div>
          </div>
        </div>
      </div>

      <div class="row g-3 mt-1">
        <div class="col-lg-5">
          <div class="card h-100">
            <div class="card-header d-flex justify-content-between align-items-center"><h6 class="mb-0">Attendance Stats (${year})</h6><small class="text-muted" id="sfAttScope"></small></div>
            <div class="card-body" id="sfAttStats">Loading...</div>
          </div>
        </div>
        <div class="col-lg-7">
          <div class="card h-100">
            <div class="card-header d-flex justify-content-between align-items-center">
              <h6 class="mb-0">Company Calendar</h6>
              <div>
                <button class="btn btn-sm btn-outline-secondary" id="sfCalPrev"><i class="fas fa-chevron-left"></i></button>
                <span class="mx-2" id="sfCalTitle"></span>
                <button class="btn btn-sm btn-outline-secondary" id="sfCalNext"><i class="fas fa-chevron-right"></i></button>
              </div>
            </div>
            <div class="card-body" id="sfHolidayCalendarWrap"></div>
          </div>
        </div>
      </div>
    `;

    document.getElementById('dashSfRefresh')?.addEventListener('click', ()=>reloadAll());
    startClock();
    await reloadAll();
    initCalendar();
  }

  function startClock(){
    const elClock = document.getElementById('clockNow');
    const elGreet = document.getElementById('greetText');
    function tick(){ if (elClock) elClock.textContent = new Date().toLocaleString(); if (elGreet) elGreet.textContent = greeting(); }
    tick(); setInterval(tick, 1000);
  }

  async function reloadAll(){
    await Promise.all([
      loadAnnouncementsTicker(),
      loadProfile(),
      loadRecentDocs(),
      loadMessages(),
      loadUpcomingPeople(),
      loadAttendanceStats()
    ]);
  }

  async function loadAnnouncementsTicker(){
    const wrap = document.getElementById('annTicker'); if (!wrap) return;
    wrap.textContent = 'Loading announcements...';
    try{
      const res = await fetch('api/announcements.php?action=latest&limit=10',{credentials:'same-origin'});
      const js = await res.json();
      const items = js?.success ? (js.data||[]) : [];
      if (!items.length){ wrap.innerHTML = '<span class="text-muted">No announcements</span>'; return; }
      const text = items.map(a=>`<span class=\"me-4\"><strong>${escapeHtml(a.title||'')}</strong>: ${escapeHtml(a.content||'')}</span>`).join('');
      wrap.innerHTML = `<div id=\"annMarquee\" style=\"display:inline-block; animation: scrollLeft 30s linear infinite;\">${text}</div>`;
      injectMarqueeStyle();
    }catch(_){ wrap.innerHTML = '<span class="text-danger">Failed to load</span>'; }
  }
  function injectMarqueeStyle(){ if (document.getElementById('mq-style')) return; const s=document.createElement('style'); s.id='mq-style'; s.textContent='@keyframes scrollLeft {0%{transform:translateX(0)}100%{transform:translateX(-50%)}}'; document.head.appendChild(s); }

  async function loadProfile(){
    const el = document.getElementById('sfProfile'); if (!el) return;
    try{
      const r = await fetch('api/analytics.php?action=people',{credentials:'same-origin'});
      const j = await r.json(); if (!j?.success){ el.innerHTML='<div class="text-danger">Failed</div>'; return; }
      const p = j.data?.profile||{}; const roles=Array.isArray(p.roles)? p.roles.map(r=>r.name).join(', '):'';
      el.innerHTML = `
        <div class="d-flex align-items-center gap-3">
          <img class="rounded-circle" src="${escapeHtml(window.auth?.currentUser?.avatar||'assets/img/avatar-default.png')}" width="56" height="56" alt="avatar">
          <div>
            <div class="fw-bold">${escapeHtml((p.first_name||'')+' '+(p.last_name||''))}</div>
            <div class="text-muted small">${escapeHtml(roles||'')}</div>
            <div class="text-muted small">Department: ${escapeHtml(p.department_name||'--')}</div>
          </div>
        </div>`;
    }catch(_){ el.innerHTML='<div class="text-danger">Failed</div>'; }
  }

  async function loadRecentDocs(){
    const el = document.getElementById('sfDocsList'); if (!el) return;
    try{
      const r = await fetch('api/documents.php?action=recent&days=7',{credentials:'same-origin'});
      const j = await r.json(); const rows = j?.success ? (j.data||[]) : [];
      el.innerHTML = rows.slice(0,8).map(d=>`<li class="list-group-item d-flex justify-content-between align-items-center">
        <div>
          <div class="fw-semibold">${escapeHtml(d.title||'')}</div>
          <div class="small text-muted">${escapeHtml(d.category||'')}${d.ack_required? ' • Ack required':''}</div>
          ${d.ack_required && !d.acked_at ? `<button class="btn btn-sm btn-outline-success mt-1" data-ack="${d.id}"><i class="fas fa-check"></i> Acknowledge</button>`:''}
        </div>
        <div class="text-end small">
          <div>${escapeHtml(formatDateTime(d.created_at))}</div>
          <a href="api/documents.php?action=download&id=${d.id}" class="btn btn-sm btn-outline-primary"><i class="fas fa-download"></i></a>
        </div>
      </li>`).join('') || '<li class="list-group-item text-muted">No recent documents</li>';
      // wire ack buttons
      el.querySelectorAll('[data-ack]')?.forEach(btn=>{ if(btn._ackBound) return; btn._ackBound=true; btn.addEventListener('click', ()=> ackDoc(Number(btn.getAttribute('data-ack')))); });
    }catch(_){ el.innerHTML = '<li class="list-group-item text-danger">Failed to load</li>'; }
  }

  async function ackDoc(id){
    if (!confirm('I have read and understood this document. Proceed to acknowledge?')) return;
    try{
      const res = await fetch('api/documents.php?action=ack',{method:'POST',headers:{'Content-Type':'application/json'},credentials:'same-origin',body:JSON.stringify({id})});
      const js = await res.json();
      if (js?.success){ window.auth?.showNotification?.('Acknowledged','success'); loadRecentDocs(); }
      else { window.auth?.showNotification?.(js?.message||'Failed to acknowledge','error'); }
    }catch(_){ window.auth?.showNotification?.('Failed to acknowledge','error'); }
  }

  async function loadMessages(){
    const el = document.getElementById('sfMsgList'); if (!el) return;
    try{
      const r = await fetch('api/messages.php?action=inbox',{credentials:'same-origin'});
      const j = await r.json(); const rows = j?.success ? (j.data||[]) : [];
      el.innerHTML = rows.slice(0,5).map(m=>`<li class="list-group-item">
        <div class="fw-semibold">${escapeHtml(m.subject||'Message')}</div>
        <div class="small text-muted">from ${escapeHtml((m.sender_first_name||'')+' '+(m.sender_last_name||m.sender_username||''))} • ${escapeHtml(formatDateTime(m.created_at))}</div>
        <div class="small">${escapeHtml(String(m.content||'').slice(0,120))}${String(m.content||'').length>120?'...':''}</div>
      </li>`).join('') || '<li class="list-group-item text-muted">No messages</li>';
    }catch(_){ el.innerHTML = '<li class="list-group-item text-danger">Failed to load</li>'; }
  }

  async function loadUpcomingPeople(){
    const bdEl = document.getElementById('sfBdList'); const anEl = document.getElementById('sfAnList');
    try{
      const r = await fetch('api/analytics.php?action=people_window&days=7',{credentials:'same-origin'});
      const j = await r.json(); if (!j?.success){ throw new Error('bad'); }
      const b = Array.isArray(j.data?.birthdays)? j.data.birthdays:[]; const a = Array.isArray(j.data?.anniversaries)? j.data.anniversaries:[];
      const end = j.data?.end; document.getElementById('sfBdRange').textContent = `until ${formatDate(end)}`; document.getElementById('sfAnRange').textContent = `until ${formatDate(end)}`;
      bdEl.innerHTML = b.length? b.map(x=>`<li class="list-group-item d-flex justify-content-between align-items-center">
        <div><div class="fw-semibold">${escapeHtml((x.first_name||'')+' '+(x.last_name||''))}</div><div class="small text-muted">${escapeHtml(x.department_name||'')} • ${formatDate(x.occurs_on)}</div></div>
        ${x.user_id? `<button class="btn btn-sm btn-outline-primary" data-wish="${x.user_id}" data-name="${escapeHtml((x.first_name||'')+' '+(x.last_name||''))}" data-type="birthday">Send wish</button>`:''}
      </li>`).join('') : '<li class="list-group-item text-muted">None</li>';
      anEl.innerHTML = a.length? a.map(x=>`<li class="list-group-item d-flex justify-content-between align-items-center">
        <div><div class="fw-semibold">${escapeHtml((x.first_name||'')+' '+(x.last_name||''))}</div><div class="small text-muted">${escapeHtml(x.department_name||'')} • ${formatDate(x.occurs_on)} • ${Number(x.years||0)} yr</div></div>
        ${x.user_id? `<button class="btn btn-sm btn-outline-primary" data-wish="${x.user_id}" data-name="${escapeHtml((x.first_name||'')+' '+(x.last_name||''))}" data-type="anniversary">Send note</button>`:''}
      </li>`).join('') : '<li class="list-group-item text-muted">None</li>';
      document.querySelectorAll('[data-wish]')?.forEach(btn=>{ if(btn._wishBound) return; btn._wishBound=true; btn.addEventListener('click', async ()=>{ const uid=Number(btn.getAttribute('data-wish')); const type=btn.getAttribute('data-type'); const name=btn.getAttribute('data-name'); const placeholder = type==='birthday' ? `Write a birthday wish to ${name}` : `Write an anniversary message to ${name}`; const msg = prompt(placeholder, type==='birthday' ? 'Happy Birthday!' : 'Happy Work Anniversary!'); if(!msg) return; try{ const r=await fetch('api/messages.php?action=send',{method:'POST',headers:{'Content-Type':'application/json'},credentials:'same-origin',body:JSON.stringify({recipient_user_id:uid, subject:type==='birthday'?'Happy Birthday':'Happy Work Anniversary', content:msg})}); const j=await r.json(); if(j?.success) window.auth?.showNotification?.('Message sent','success'); else window.auth?.showNotification?.(j?.message||'Failed','error'); }catch(_){ window.auth?.showNotification?.('Failed','error'); } }); });
    }catch(_){ if (bdEl) bdEl.innerHTML='<li class="list-group-item text-danger">Failed to load</li>'; if (anEl) anEl.innerHTML='<li class="list-group-item text-danger">Failed to load</li>'; }
  }

  async function loadAttendanceStats(){
    const el = document.getElementById('sfAttStats'); const scopeEl = document.getElementById('sfAttScope'); if (!el) return;
    try{
      const r = await fetch('api/attendance.php?action=stats_year',{credentials:'same-origin'});
      const j = await r.json(); if (!j?.success){ throw new Error('bad'); }
      const d = j.data||{}; if (scopeEl) scopeEl.textContent = (d.scope||'').toUpperCase();
      el.innerHTML = `
        <div class="row text-center">
          <div class="col-4"><div class="h4">${Number(d.clock_in_total ?? d.clock_in ?? 0)}</div><div class="text-muted small">Clock-ins</div></div>
          <div class="col-4"><div class="h4">${Number(d.clock_out_total ?? d.clock_out ?? 0)}</div><div class="text-muted small">Clock-outs</div></div>
          <div class="col-4"><div class="h4">${Number(d.records||0)}</div><div class="text-muted small">Records</div></div>
        </div>`;
    }catch(_){ el.innerHTML = '<div class="text-danger">Failed</div>'; }
  }

  // Calendar
  let sfCalState = null;
  function initCalendar(){
    const wrap = document.getElementById('sfHolidayCalendarWrap'); if (!wrap) return;
    const now = new Date(); sfCalState = {year: now.getFullYear(), month: now.getMonth()};
    document.getElementById('sfCalPrev')?.addEventListener('click', ()=>shift(-1));
    document.getElementById('sfCalNext')?.addEventListener('click', ()=>shift(1));
    renderCal();
  }
  function shift(d){ if (!sfCalState) return; let y=sfCalState.year, m=sfCalState.month+d; while(m<0){m+=12;y--;} while(m>11){m-=12;y++;} sfCalState.year=y; sfCalState.month=m; renderCal(); }
  async function renderCal(){
    const wrap = document.getElementById('sfHolidayCalendarWrap'); const title = document.getElementById('sfCalTitle'); if (!wrap||!title||!sfCalState) return;
    const y=sfCalState.year, m=sfCalState.month; const first = new Date(y,m,1); const last = new Date(y,m+1,0);
    title.textContent = first.toLocaleString(undefined,{month:'long',year:'numeric'});
    const from = `${y}-${String(m+1).padStart(2,'0')}-01`; const to = `${y}-${String(m+1).padStart(2,'0')}-${String(last.getDate()).padStart(2,'0')}`;
    let holidays = {}; let eventsByDate = {};
    try{
      const rh = await fetch(`api/holidays.php?action=range&from=${from}&to=${to}`,{credentials:'same-origin'}); const jh = await rh.json(); if (jh?.success) jh.data.forEach(r=>{ holidays[r.holiday_date]=r.name||'Holiday'; });
      const re = await fetch(`api/calendar.php?action=range&from=${from}&to=${to}`,{credentials:'same-origin'}); const je = await re.json(); if (je?.success) je.data.forEach(ev=>{ const d = new Date(String(ev.start_at||'').replace(' ','T')); if (!isNaN(d)){ const key = `${d.getFullYear()}-${String(d.getMonth()+1).padStart(2,'0')}-${String(d.getDate()).padStart(2,'0')}`; (eventsByDate[key]=eventsByDate[key]||[]).push({title:ev.title||'Event'}); } });
    }catch(_){}
    const startDow = (first.getDay()+6)%7; const days=last.getDate(); const cells=[]; for(let i=0;i<startDow;i++) cells.push(null); for(let d=1; d<=days; d++) cells.push(new Date(y,m,d)); while(cells.length%7!==0) cells.push(null);
    const head=['Mon','Tue','Wed','Thu','Fri','Sat','Sun']; let html='<div class="table-responsive"><table class="table table-bordered table-sm mb-0"><thead><tr>'+head.map(h=>`<th class="text-center">${h}</th>`).join('')+'</tr></thead><tbody>';
    for(let i=0;i<cells.length;i+=7){ html+='<tr>'; for(let j=0;j<7;j++){ const dt=cells[i+j]; if(!dt){ html+='<td class="bg-light"></td>'; continue; } const key=`${dt.getFullYear()}-${String(dt.getMonth()+1).padStart(2,'0')}-${String(dt.getDate()).padStart(2,'0')}`; const isWeekend = dt.getDay()===0||dt.getDay()===6; const badgeHol = holidays[key]? `<div class="badge bg-danger w-100">${escapeHtml(holidays[key])}</div>` : (isWeekend? '<div class="badge bg-secondary w-100">Weekend</div>' : ''); const evs = eventsByDate[key]||[]; let evHtml=''; if (evs.length){ const max=2; evs.slice(0,max).forEach(e=>{ evHtml+=`<div class="badge bg-primary w-100 text-truncate" title="${escapeHtml(e.title)}">${escapeHtml(e.title)}</div>`; }); if (evs.length>max){ evHtml+=`<div class="small text-primary">+${evs.length-max} more</div>`; } } html+=`<td style="vertical-align:top;min-width:116px"><div class="small fw-bold">${dt.getDate()}</div>${badgeHol}${evHtml}</td>`; } html+='</tr>'; }
    html+='</tbody></table></div>'; wrap.innerHTML = html;
  }

  window.pages.dashboard_staff = { render };
})();
