<?php
/**
 * Client Logging API
 * Accepts JSON logs from the browser and writes to activity_logs table and file log with correlation ID.
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

require_once '../config/database.php';

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    ApiResponse::success(null, 'OK');
}

$database = new Database();
$db = $database->getConnection();

$input = json_decode(file_get_contents('php://input'), true) ?? [];

$level = $input['level'] ?? 'info';
$message = $input['message'] ?? 'client_log';
$data = [
    'page' => $input['page'] ?? null,
    'url' => $input['url'] ?? null,
    'method' => $input['method'] ?? null,
    'status' => $input['status'] ?? null,
    'duration_ms' => $input['duration_ms'] ?? null,
    'error' => $input['error'] ?? null,
    'context' => $input['context'] ?? null,
    'request_id' => $input['request_id'] ?? get_request_id(),
];

// File log
app_log($level, $message, $data);

// DB log (activity_logs)
try {
    $userId = $_SESSION['user_id'] ?? null;
    $stmt = $db->prepare("INSERT INTO activity_logs (user_id, action, data, ip_address, user_agent, created_at) VALUES (:user_id, :action, :data, :ip, :ua, NOW())");
    $stmt->bindValue(':user_id', $userId);
    $stmt->bindValue(':action', $message);
    $stmt->bindValue(':data', json_encode($data));
    $stmt->bindValue(':ip', $_SERVER['REMOTE_ADDR'] ?? null);
    $stmt->bindValue(':ua', $_SERVER['HTTP_USER_AGENT'] ?? null);
    $stmt->execute();
} catch (Throwable $e) {
    // Continue even if DB logging fails
}

ApiResponse::success(['request_id' => get_request_id()], 'Logged');
