<?php
// Common helper handlers for leave requests that need to be available to all HTTP methods

if (!function_exists('getLeaveRequest')) {
    function getLeaveRequest(PDO $db, $id){
        $user = getCurrentUser();
        $q = "SELECT lr.*, lt.name AS leave_type_name, CONCAT(e.first_name,' ',e.last_name) AS employee_name
              FROM leave_requests lr
              JOIN leave_types lt ON lt.id = lr.leave_type_id
              JOIN employees e ON e.id = lr.employee_id
              WHERE lr.id = :id AND e.company_id = :cid";
        $st = $db->prepare($q);
        $st->bindValue(':id', $id, PDO::PARAM_INT);
        $st->bindValue(':cid', $user['company_id'], PDO::PARAM_INT);
        $st->execute();
        if ($st->rowCount() === 0) ApiResponse::notFound('Leave request not found');
        ApiResponse::success($st->fetch());
    }
}

if (!function_exists('updateLeaveRequest')) {
    function updateLeaveRequest(PDO $db, $id){
        $user = getCurrentUser();
        $input = json_decode(file_get_contents('php://input'), true) ?? [];
        // Allow employee to update their own pending request dates/reason
        $check = $db->prepare("SELECT lr.*, e.user_id FROM leave_requests lr JOIN employees e ON e.id = lr.employee_id WHERE lr.id = :id AND lr.status = 'pending'");
        $check->bindValue(':id', $id, PDO::PARAM_INT);
        $check->execute();
        if ($check->rowCount() === 0) ApiResponse::error('Only pending requests can be updated');
        $row = $check->fetch();
        if ((int)$row['user_id'] !== (int)$user['id']) ApiResponse::forbidden('Not your request');
        $fields = [];
        $params = [':id'=>$id];
        foreach (['start_date','end_date','reason'] as $f){ if (isset($input[$f])) { $fields[] = "$f = :$f"; $params[":$f"] = $input[$f]; } }
        if (!$fields) ApiResponse::error('Nothing to update');
        $sql = 'UPDATE leave_requests SET '.implode(',', $fields).', updated_at = NOW() WHERE id = :id';
        $st = $db->prepare($sql);
        foreach ($params as $k=>$v) $st->bindValue($k,$v);
        $st->execute();
        ApiResponse::success(null,'Request updated');
    }
}

if (!function_exists('cancelLeaveRequest')) {
    function cancelLeaveRequest(PDO $db, $id){
        $user = getCurrentUser();
        // Employee can cancel own pending; approvers/admin can also cancel
        $check = $db->prepare("SELECT lr.*, e.user_id, e.company_id FROM leave_requests lr JOIN employees e ON e.id = lr.employee_id WHERE lr.id = :id AND lr.status = 'pending'");
        $check->bindValue(':id', $id, PDO::PARAM_INT);
        $check->execute();
        if ($check->rowCount() === 0) ApiResponse::error('Only pending requests can be cancelled');
        $row = $check->fetch();
        $role = $user['role_slug'] ?? '';
        $isApprover = in_array($role, ['super_admin','admin','hr_head','manager'], true);
        if ((int)$row['user_id'] !== (int)$user['id'] && !$isApprover) ApiResponse::forbidden('Not allowed to cancel');
        $st = $db->prepare("UPDATE leave_requests SET status = 'cancelled', updated_at = NOW() WHERE id = :id");
        $st->bindValue(':id', $id, PDO::PARAM_INT);
        $st->execute();
        ApiResponse::success(null,'Request cancelled');
    }
}
